﻿using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    [DefaultProperty("MappingName")]
    [ToolboxData("<{0}:MCheckBox runat=server></{0}:MCheckBox>")]
    public class MCheckBox : CheckBox, Framework.Web.UI.IMappingControl, IInputControl, ILocalizeControl
    {

        [Category("Custom")]
        [DefaultValue("")]
        public string MappingName { get; set; }

        [Category("Custom")]
        [DefaultValue("1")]
        public string CheckedValue
        {
            get { return _checkedValue; }
            set { _checkedValue = value; }
        }
        private string _checkedValue = BoolString.True;

        [Category("Custom")]
        [DefaultValue("0")]
        public string UncheckedValue
        {
            get { return _uncheckedValue; }
            set { _uncheckedValue = value; }
        }
        private string _uncheckedValue = BoolString.False;

        [Category("Custom")]
        [DefaultValue("false")]
        public bool DefaultChecked { get; set; }


        [Category("Custom")]
        [DefaultValue("")]
        public string LTextKey { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MCheckBox()
        {
            this.DefaultChecked = false;
        }

        #region IMappingControl メンバ

        void IMappingControl.RequestMappingData(Framework.Data.MappingData data)
        {
            if (this.MappingName.IsNotEmpty())
            {
                string val = base.Checked ? this.CheckedValue : this.UncheckedValue;
                data.Add(this.MappingName, val);
            }
        }

        void IMappingControl.SetMappingData(Framework.Data.MappingData data)
        {
            if (this.MappingName.IsNotEmpty())
            {
                string val = data[this.MappingName];
                if (val != null)
                {
                    base.Checked = (val == this.CheckedValue);
                }
            }
        }

        #endregion

        #region IInputControl メンバ

        public bool IsValid
        {
            get { return _isValid; }
            set { _isValid = value; }
        }
        private bool _isValid = true;

        public System.Web.UI.Control GetErrorControl()
        {
            return this;
        }

        public bool IsInputed()
        {
            return base.Checked != this.DefaultChecked;
        }

        public bool IsBlank()
        {
            return base.Checked == false;
        }

        public bool ValidateInput(bool dataTypeOnly)
        {
            return true;
        }

        public void SetValidateResult(bool isSuccess)
        {
            this.IsValid = (this.IsValid && isSuccess);
            base.BackColor = this.IsValid ? UIController.ValidateSuccessColor : UIController.ValidateErrorColor;
        }

        public void ClearInput()
        {
            base.Checked = this.DefaultChecked;
        }

        public string GetInputValue()
        {
            return base.Checked ? this.CheckedValue : this.UncheckedValue;
        }

        #endregion

        #region ILocalizeControl メンバ

        public void Localize(System.Globalization.CultureInfo lang)
        {
            if (this.LTextKey.IsNotEmpty())
            {
                base.Text = LTextMgr.GetText(lang, this.LTextKey);
            }
        }

        #endregion
    }
}
